/*
 * This is a stripped down starter code for the
 * Assembly Summer 2019 Demo Coding Workshop
 * The original invitation code is very educational:
 * https://github.com/mrautio/graffathon19-demo-one-scene 
 */

// We suggest you use these libraries (and no others):
// Moonlander is a library for integrating Processing with GNU Rocket, https://github.com/anttihirvonen/moonlander
// GNURocket is a tool for synchronizing music and visuals in demoscene productions: https://github.com/rocket/rocket
import moonlander.library.*;
// Audio library for playing sound, http://code.compartmental.net/minim/
import ddf.minim.*;

// Some demo global variables 

// the time in seconds (will be taken from Moonlander / GNURocket every frame)
float now = 0.0;

// These control how big the opened window is.
// But you don't need not change these to develop in a smaller window!
// In fact, DON'T CHANGE THESE. They are optimal for Assembly 2019 Compo.
// ref. https://www.assembly.org/summer19/demoscene/rules
float CANVAS_WIDTH = 1920;
float CANVAS_HEIGHT = 1080;

Moonlander moonlander;

/*
 * Initialize the window
 */
void settings() {
  boolean fullscreen = true;

  if (fullscreen) {
    //Set the window fullscreen in desktop's native resolution
    fullScreen(P3D);
  } else {
    //open in a smaller window
    //Put some 16:9 aspect ratio resolution
    //like 800x450... do not edit CANVAS_WIDTH or CANVAS_HEIGHT
    size((int)800, (int)450, P3D);
  }
}

/*
 * Set up, and load all assets in the demo.
 * Make sure you include everything in the "data/" directory 
 * with your entry, and that the license of each asset allows
 * you to use it in this compo!
 */
void setup() {
  // hide mouse cursor; you want to do this.
  noCursor();


  // Init & start moonlander
  int bpm = 120; // Tune's beats per minute. Set this according to your song.
  int rowsPerBeat = 4; // How many rows one beat consists of in the sync editor (GNURocket or so)
  moonlander = Moonlander.initWithSoundtrack(this, "deep-and-dirty-by-kevin-macleod.mp3", bpm, rowsPerBeat);
  moonlander.start();

  // Assembly has 60Hz maximum projector framerate, ref. https://www.assembly.org/summer19/demoscene/rules
  int fps = 60;
  frameRate(fps);
}



void paksuteksti(float x, float y, float z){
  text("MAYHEM",x,y,z);
  text("MAYHEM",x+5,y,z);
  text("MAYHEM",x-5,y,z);
  
  text("MAYHEM",x,y-5,z);
  text("MAYHEM",x+5,y-5,z);
  text("MAYHEM",x-5,y-5,z);
  
  text("MAYHEM",x,y+5,z);
  text("MAYHEM",x+5,y+5,z);
  text("MAYHEM",x-5,y+5,z);
}

void paksuteksti2(float x, float y, float z){
  text("MAYHEM",x,y,z);
  text("MAYHEM",x+5,y,z);
  text("MAYHEM",x-5,y,z);
  
  text("MAYHEM",x,y-5,z);
  text("MAYHEM",x+5,y-5,z);
  text("MAYHEM",x-5,y-5,z);
  
  text("MAYHEM",x,y+5,z);
  text("MAYHEM",x+5,y+5,z);
  text("MAYHEM",x-5,y+5,z);
}

void pikkuteksti(float x, float y, float z){
  
  text("MAYHEM",x+600,0);
  text("MAYHEM",x-600,0);
  
  text("MAYHEM",x-600,y-400);
  text("MAYHEM",x-600,y+400);
  
  text("MAYHEM",0,y+400);
  text("MAYHEM",0,y-400);
  
  text("MAYHEM",x+600,y-400);
  text("MAYHEM",x+600,y+400);
  
  
}

void scene3() {
  println("scene3"); 
 
    
    fill(255, 0, 0); 
    textSize(250);
    paksuteksti(-20,-2,0);
    
  
  
    fill(255, 255, 0); 
    textSize(250);
    textAlign(CENTER, CENTER);
    paksuteksti(0,0,0);

}

void scene1() {
  println("scene1"); 
  
    fill(255, 0, 0); 
    textSize(250);
    paksuteksti(4.0*cos(5.0*millis())-20,4.0*cos(5.0*millis()),4.0*cos(5.0*millis()));
    
  
  
    fill(255, 255, 0); 
    textSize(250);
    textAlign(CENTER, CENTER);
    paksuteksti(4.0*cos(5.0*millis()),4.0*cos(5.0*millis()),4.0*cos(5.0*millis()));

}

void scene2() {
  println("scene2");
  
    text("MAYHEM",0,0);
    fill(255,0,255); 
    textSize(250);
    paksuteksti2(-20,-2,0);
    
    text("MAYHEM",0,0);
    fill(0,255,0); 
    textSize(250);
    textAlign(CENTER, CENTER);
    paksuteksti2(0,0,0);
      
}


void scene4() {
  println("scene4");
  
    text("MAYHEM",0,0,0);
    fill(255,0,255); 
    textSize(90);
    pikkuteksti(-7,-2,0);
    
    text("MAYHEM",0,0);
    fill(0,255,0); 
    textSize(90);
    textAlign(CENTER, CENTER);
    pikkuteksti(0,0,0);
      
}

void scene5() {
  println("scene5");
  
    
    text("KIITOS",0,-300);
    fill(255,255,255); 
    textSize(60);
    textAlign(CENTER, TOP);
    
    text("Kavereille vertaistuesta",0,-100);
    fill(255,255,255); 
    textSize(60);
    textAlign(CENTER, TOP);
    
    text("Workshopin vetäjille",0,0);
    fill(255,255,255); 
    textSize(60);
    textAlign(CENTER, TOP);
    
    text("Musat: Kevin MacLeod - Deep And Dirty",0,+100);
    fill(255,255,255); 
    textSize(60);
    textAlign(CENTER, TOP);
    
    text("https://incompetech.filmmusic.io/song/5045-deep-and-dirty/",0,+200);
    fill(255,255,255); 
    textSize(60);
    textAlign(CENTER, TOP);
      
}


/*
 * This function is called every time a screen is drawn, ideally that would be 60 times per second
 */
void draw() {
  // update Rocket sync data  
  moonlander.update();

  now = (float)moonlander.getCurrentTime();
  float end = 60.0; //end production after 60 secs which is the maximum time allowed by the One Scene Compo
  if (now > end) {
    exit();
  }

  // Oma lisäys
  int scene = moonlander.getIntValue("scene");




  // Set the background color
  background((int)(moonlander.getValue("bg:r") ), 
    (int)(moonlander.getValue("bg:g") ), 
    (int)(moonlander.getValue("bg:b") ), 
    (int)(moonlander.getValue("bg:a") ));

  /*
   * Center coordinates to screen and make the window and canvas resolution independent
   * This is because actual window in full screen on a 4K monitor has more pixels than FullHD resolution
   * so scaling is needed to ensure that all objects (3D and 2D) are in correct places regardless of the desktop resolution
   */
  translate(width/2, height/2, 0);
  scale(width/CANVAS_WIDTH, height/CANVAS_HEIGHT, width/CANVAS_WIDTH);
  
    println(scene); 
  
    if (scene == 3) {
    scene3();
  }
  
  if (scene == 1) {
    scene1();
  }

  if (scene == 2) {
    scene2();
  }
  
    if (scene == 4) {
    scene4();
  }
  
      if (scene == 5) {
    scene5();
  }

      if (scene == 100) {
    exit();
  }
  
  // Enable lights and depth testing to ensure that 3D meshes are drawn in correct order
  lights();
  hint(ENABLE_DEPTH_TEST);
}
